topic "Scp";
[2 $$0,0#00000000000000000000000000000000:Default]
[i448;a25;kKO9;2 $$1,0#37138531426314131252341829483380:class]
[l288;2 $$2,2#27521748481378242620020725143825:desc]
[0 $$3,0#96390100711032703541132217272105:end]
[H6;0 $$4,0#05600065144404261032431302351956:begin]
[i448;a25;kKO9;2 $$5,0#37138531426314131252341829483370:item]
[l288;a4;*@5;1 $$6,6#70004532496200323422659154056402:requirement]
[l288;i1121;b17;O9;~~~.1408;2 $$7,0#10431211400427159095818037425705:param]
[i448;b42;O9;2 $$8,8#61672508125594000341940100500538:tparam]
[b42;2 $$9,9#13035079074754324216151401829390:normal]
[{_} 
[ {{10000@(113.42.0) [s0;%% [*@7;4 Scp]]}}&]
[s0; &]
[s1;:Upp`:`:Scp`:`:class: [@(0.0.255)3 class][3 _][*3 Scp][3 _:_][@(0.0.255)3 public][3 _][*@3;3 Cha
nnel]&]
[s2;#%% This class encapsulates the [^https`:`/`/en`.wikipedia`.org`/wiki`/Secure`_copy`?oldformat`=true^ s
ecure copy] (SCP) subsystem. It provides a means for securely 
transferring files between a local host and a remote host.&]
[s3; &]
[ {{10000F(128)G(128)@1 [s0;%% [* Public Method List]]}}&]
[s3; &]
[s5;:Upp`:`:Scp`:`:Put`(Upp`:`:Stream`&`,const Upp`:`:String`&`,long`,Upp`:`:Gate`<Upp`:`:int64`,Upp`:`:int64`>`): [@(0.0.255) b
ool]_[* Put]([_^Upp`:`:Stream^ Stream][@(0.0.255) `&]_[*@3 in], [@(0.0.255) const]_[_^Upp`:`:String^ S
tring][@(0.0.255) `&]_[*@3 path], [@(0.0.255) long]_[*@3 mode], [_^Upp`:`:Gate^ Gate]<[_^Upp`:`:int64^ i
nt64], [_^Upp`:`:int64^ int64]>_[*@3 progress]_`=_Null)&]
[s0; [@(0.0.255) bool]_[* operator()]([_^Upp`:`:Stream^ Stream][@(0.0.255) `&]_[*@3 in], 
[@(0.0.255) const]_[_^Upp`:`:String^ String][@(0.0.255) `&]_[*@3 path], 
[@(0.0.255) long]_[*@3 mode], [_^Upp`:`:Gate^ Gate]<[_^Upp`:`:int64^ int64], 
[_^Upp`:`:int64^ int64]>_[*@3 progress]_`=_Null)&]
[s2;%% Uploads the local data at [%-*@3 in] to remote file at [%-*@3 path], 
with access [%-*@3 flags] and [%-*@3 mode]. Returns true on success. 
[%-*@3 progress ]function can be used to track the progress of 
the upload; returning true will abort the operation. This method 
is blocking. .&]
[s3;%% &]
[s4; &]
[s5;:Upp`:`:Scp`:`:StartPut`(Upp`:`:Stream`&`,const Upp`:`:String`&`,long`,Upp`:`:Gate`<Upp`:`:int64`,Upp`:`:int64`>`): [_^Upp`:`:Scp^ S
cp][@(0.0.255) `&]_[* StartPut]([_^Upp`:`:Stream^ Stream][@(0.0.255) `&]_[*@3 in], 
[@(0.0.255) const]_[_^Upp`:`:String^ String][@(0.0.255) `&]_[*@3 path], 
[@(0.0.255) long]_[*@3 mode], [_^Upp`:`:Gate^ Gate]<[_^Upp`:`:int64^ int64], 
[_^Upp`:`:int64^ int64]>_[*@3 progress])&]
[s2;%% Asynchronous variant of [^topic`:`/`/SSH`/src`/Ssh`_SFtp`$en`-us`#Upp`:`:SFtp`:`:Put`(const Upp`:`:Stream`&`,Upp`:`:Gate`<Upp`:`:int64`,Upp`:`:int64`>`)^ P
ut()]. Must be followed by a [^topic`:`/`/JobQueue`/src`/JobQueue`$en`-us`#Upp`:`:JobQueue`:`:Do`(`)^ D
o()] call. Returns `*this for method chaining. &]
[s2;%% [* Caution]: Object life time is a crucial parameter to take 
into account here. Do not let the calls to [^topic`:`/`/JobQueue`/src`/JobQueue`$en`-us`#Upp`:`:JobQueue`:`:Do`(`)^ D
o()] method outlive the [%-*@3 in][*  ]Stream. Otherwise your application 
will crash.&]
[s3;%% &]
[s4; &]
[s5;:Upp`:`:Scp`:`:Get`(Upp`:`:Stream`&`,const Upp`:`:String`&`,Upp`:`:Gate`<Upp`:`:int64`,Upp`:`:int64`>`): [@(0.0.255) b
ool]_[* Get]([_^Upp`:`:Stream^ Stream][@(0.0.255) `&]_[*@3 out], [@(0.0.255) const]_[_^Upp`:`:String^ S
tring][@(0.0.255) `&]_[*@3 path], [_^Upp`:`:Gate^ Gate]<[_^Upp`:`:int64^ int64], 
[_^Upp`:`:int64^ int64]>_[*@3 progress]_`=_Null)&]
[s5;:Upp`:`:Scp`:`:operator`(`)`(Upp`:`:Stream`&`,const Upp`:`:String`&`,Upp`:`:Gate`<Upp`:`:int64`,Upp`:`:int64`>`): [@(0.0.255) b
ool]_[* operator()]([_^Upp`:`:Stream^ Stream][@(0.0.255) `&]_[*@3 out], 
[@(0.0.255) const]_[_^Upp`:`:String^ String][@(0.0.255) `&]_[*@3 path], 
[_^Upp`:`:Gate^ Gate]<[_^Upp`:`:int64^ int64], [_^Upp`:`:int64^ int64]>_[*@3 progress]_`=
_Null)&]
[s2;%% Downloads the remote file at [%-*@3 path] to local [%-*@3 out]. 
Returns true on success. [%-*@3 progress ]function can be used 
to track the progress of the download; returning true will abort 
the operation. This method is blocking.&]
[s3;%% &]
[s4; &]
[s5;:Upp`:`:Scp`:`:StartGet`(Upp`:`:Stream`&`,const Upp`:`:String`&`,Upp`:`:Gate`<Upp`:`:int64`,Upp`:`:int64`>`): [_^Upp`:`:Scp^ S
cp][@(0.0.255) `&]_[* StartGet]([_^Upp`:`:Stream^ Stream][@(0.0.255) `&]_[*@3 out], 
[@(0.0.255) const]_[_^Upp`:`:String^ String][@(0.0.255) `&]_[*@3 path], 
[_^Upp`:`:Gate^ Gate]<[_^Upp`:`:int64^ int64], [_^Upp`:`:int64^ int64]>_[*@3 progress])&]
[s2;%% Asynchronous variant of [^topic`:`/`/SSH`/src`/Ssh`_SFtp`$en`-us`#Upp`:`:SFtp`:`:Get`(Upp`:`:Stream`&`,Upp`:`:Gate`<Upp`:`:int64`,Upp`:`:int64`>`)^ G
et()]. Must be followed by a [^topic`:`/`/JobQueue`/src`/JobQueue`$en`-us`#Upp`:`:JobQueue`:`:Do`(`)^ D
o()] call. Returns `*this for method chaining. &]
[s2;%% [* Caution]: Object life time is a crucial parameter to take 
into account here. Do not let the calls to [^topic`:`/`/JobQueue`/src`/JobQueue`$en`-us`#Upp`:`:JobQueue`:`:Do`(`)^ D
o()] method outlive the [%-*@3 out ]Stream. Otherwise your application 
will crash.&]
[s3;%% &]
[ {{10000F(128)G(128)@1 [s0;%% [* Constructor detail]]}}&]
[s3; &]
[s5;:Upp`:`:Scp`:`:Scp`(`): [* Scp]()&]
[s2;%% Default constructor. In order for the Scp instances constructed 
this way to be valid, they must be bound to a valid ssh session 
first, using [^topic`:`/`/SSH`/src`/Ssh`$en`-us`#Upp`:`:Ssh`:`:Subsystem`:`:Session`(Upp`:`:Ssh`&`)^ S
ubsystem`::Session()] method. &]
[s3; &]
[s4; &]
[s5;:Upp`:`:Scp`:`:Scp`(Upp`:`:Ssh`&`): [* Scp]([_^Upp`:`:Ssh^ Ssh][@(0.0.255) `&]_[*@3 sessi
on])&]
[s2;%% Equivalent of the default constructor and then invoking [^topic`:`/`/SSH`/src`/Ssh`$en`-us`#Upp`:`:Ssh`:`:Subsystem`:`:Session`(Upp`:`:Ssh`&`)^ S
ubsystem`::Session()]. Binds the Scp instance to a given ssh [%-*@3 session]. 
Using this constructor is recommended.&]
[s0;%% ]]